import { DevicePluginWeb, WebPlugin, } from "@capacitor/core";
const { app } = require("electron").remote;
const webDevice = new DevicePluginWeb();
export class DevicePluginElectron extends WebPlugin {
    constructor() {
        super({
            name: "Device",
            platforms: ["electron"],
        });
    }
    async getInfo() {
        var info = await webDevice.getInfo();
        return {
            appId: info.appId,
            appName: info.appName,
            model: info.model,
            platform: "electron",
            appVersion: app.getVersion(),
            appBuild: "",
            operatingSystem: info.operatingSystem,
            osVersion: info.osVersion,
            manufacturer: navigator.vendor,
            isVirtual: false,
            uuid: info.uuid,
        };
    }
    async getBatteryInfo() {
        var batInfo = await webDevice.getBatteryInfo();
        return {
            batteryLevel: batInfo.batteryLevel,
            isCharging: batInfo.isCharging,
        };
    }
    async getLanguageCode() {
        return webDevice.getLanguageCode();
    }
}
const Device = new DevicePluginElectron();
export { Device };
//# sourceMappingURL=device.js.map